/*****************************************************************************
 *
 * Copyright 2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "seq_static.h"

#define CAM0_BEAT_DIV	1
#define CHGAIN_EXPOSURE_BEAT_DIV	2

#define CAM0_START	0
#define CHGAIN_EXPOSURE_START	(CAM0_START + CAM0_BEAT_DIV * 51)
#define VIGNETTING_START	(CHGAIN_EXPOSURE_START + CHGAIN_EXPOSURE_BEAT_DIV * 1)
#define DEBAYER_G_START	(VIGNETTING_START + CHGAIN_EXPOSURE_BEAT_DIV * 3)
#define DEBAYER_BR_START	(DEBAYER_G_START + CHGAIN_EXPOSURE_BEAT_DIV * 3)
#define RGB_2_YUV_START	(DEBAYER_BR_START + CHGAIN_EXPOSURE_BEAT_DIV * 1)
#define DENOISEFILTER_START	(RGB_2_YUV_START + CHGAIN_EXPOSURE_BEAT_DIV * 5)
#define CONVERTOUT_START	(DENOISEFILTER_START + CHGAIN_EXPOSURE_BEAT_DIV * 1)
#define ISP_UYVY_OUTPUT_START	(CONVERTOUT_START + CHGAIN_EXPOSURE_BEAT_DIV * 1)
/*****************************************************************************/

void StaticSequencing(void)
{
  sStaticSeq = STAT_SEQ_MIPI;
  initIPUnode (3, CHGAIN_EXPOSURE_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (7, VIGNETTING_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (4, DEBAYER_G_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (5, DEBAYER_BR_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (6, RGB_2_YUV_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (8, DENOISEFILTER_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initIPUnode (2, CONVERTOUT_START, CHGAIN_EXPOSURE_BEAT_DIV, 0); 
  initFDMAnode(0, ISP_UYVY_OUTPUT_START, CHGAIN_EXPOSURE_BEAT_DIV);
} // StaticSequencing()
/* EOF */
